using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.DAL
{
	public partial class TOOL_ANSWERDB : VIRP.DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public TOOL_ANSWERDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public TOOL_ANSWER GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 TOOL_ANSWER_ID)
		{
			TOOL_ANSWER objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_TOOL_ANSWER_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, TOOL_ANSWER_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<TOOL_ANSWER> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<TOOL_ANSWER> objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_TOOL_ANSWER_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, TOOL_ANSWER objSave)
		{
			Int32? objReturn = objSave.TOOL_ANSWER_ID;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_TOOL_ANSWER_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.CLINICAL_RELEVANT_FLAG, DateTime.Now, objSave.CREATEDBY, objSave.EDITABLE, objSave.HELP, objSave.ORDER, objSave.STANDARD_FLAG, objSave.TEXT, ref objReturn, objSave.TOOL_QUESTION_ID, DateTime.Now, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 TOOL_ANSWER_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_TOOL_ANSWER_delete(CURRENT_USER, CURRENT_REGISTRY_ID, TOOL_ANSWER_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
